﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Masters.Measurement
{
    public partial class EditMeasurement : System.Web.UI.Page
    {
        private ProductMeasurement myMeasurement;

        protected void Page_Load(object sender, EventArgs e)
        {
           WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                if (Request.QueryString["UniqueID"] != null)
                {
                    hdMeasurementID.Value = Request.QueryString["UniqueID"].ToString();
                    ShowProductMeasurement();
                }
            }
        }

        private void ShowProductMeasurement()
        {
            myMeasurement = ProductMeasurementBL.GetItem(Guid.Parse(hdMeasurementID.Value.Trim()), string.Empty);
            if (myMeasurement != null)
            {
                hdMeasurementID.Value = myMeasurement.UniqueID.ToString();
                txtMeasurementName.Text = myMeasurement.MeasurementName;
                txtSequenceNo.Text = myMeasurement.SequenceNo.ToString();
                chkIsActive.Checked = myMeasurement.IsActive;
            }
        }

        protected void btnSave_Click(object sender, EventArgs e)
        {
            if (ValidatePageValue())
            {
                myMeasurement = new ProductMeasurement();
                if (hdMeasurementID.Value.Trim().Length == 0)
                    myMeasurement.Mode = GlobalConfigurations.Mode.Insert;
                else
                {
                    myMeasurement.Mode = GlobalConfigurations.Mode.Update;
                    myMeasurement.UniqueID = Guid.Parse(hdMeasurementID.Value.Trim());
                }

                myMeasurement.MeasurementName = txtMeasurementName.Text.Trim();
                myMeasurement.SequenceNo = int.Parse(txtSequenceNo.Text.Trim());
                myMeasurement.IsActive = chkIsActive.Checked;
                myMeasurement.UserAccountID = (WebSession.CurrentAdminUser != null ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty);

                if (ProductMeasurementBL.Save(myMeasurement))
                {
                    WebUtilities.OpenNewAddEditDialog(this, "Success", "Product Measurement details has been saved successfully.<br>Do you want to add another Product Measurement?", this.ResolveClientUrl("~/Admin/Masters/Measurement/Measurements.aspx"));
                }
            }
        }

        protected void btnCancel_Click(object sender, EventArgs e)
        {
            Response.Redirect("~/Admin/Masters/Measurement/Measurements.aspx", false);
        }

        private bool ValidatePageValue()
        {
            if (!ValidationUtility.ValidateString(txtMeasurementName.Text.Trim()))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Verde", "validationMsgBottom('#" + txtMeasurementName.ClientID + "', 'Please enter Product Measurement Name.'); ", true);
                return false;
            }

            if (!ValidationUtility.ValidateInt(txtSequenceNo.Text.Trim()))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Verde", "validationMsgBottom('#" + txtSequenceNo.ClientID + "', 'Please enter valid Display Order.'); ", true);
                return false;
            }

            return true;
        }
    }
}